# from flask import Flask, request, jsonify, send_from_directory, send_file
# from flask_cors import CORS
# from extractor import extract_video_info, download_video
# import os

# app = Flask(__name__)
# CORS(app)

# @app.route('/')
# def index():
#     return send_from_directory('.', 'index.html')

# @app.route('/extract', methods=['POST'])
# def extract():
#     data = request.get_json()
#     url = data.get('url')
    
#     if not url:
#         return jsonify({'error': 'No URL provided'}), 400
    
#     try:
#         result = extract_video_info(url)
#         return jsonify(result)
#     except Exception as e:
#         return jsonify({'error': str(e)}), 500

# @app.route('/download/<path:filename>')
# def download_file(filename):
#     try:
#         return send_file(filename, as_attachment=True)
#     except Exception as e:
#         return jsonify({'error': str(e)}), 500

# if __name__ == '__main__':
#     app.run(debug=True, port=5000)

from flask import Flask, request, jsonify, send_from_directory
from flask_cors import CORS
from extractor import extract_video_info

app = Flask(__name__)
CORS(app)

@app.route('/')
def index():
    return send_from_directory('.', 'index.html')

@app.route('/extract', methods=['POST'])
def extract():
    data = request.get_json()
    url = data.get('url')
    
    if not url:
        return jsonify({'error': 'No URL provided'}), 400
    
    try:
        result = extract_video_info(url)
        return jsonify(result)
    except Exception as e:
        return jsonify({'error': str(e)}), 500

if __name__ == '__main__':
    app.run(debug=True, port=5000)